#include <bits/stdc++.h>

using namespace std;

const int mxN = 1e5 + 12;

int st[4 * mxN];

int _n;
const int NEUTRAL = (1 << 20) - 1;

void build(const vector<int> &v, int i = 1, int l2 = 0, int r2 = _n - 1) {
    if(l2 == r2) {
        st[i] = v[l2];
        return;
    }

    int m2 = (l2 + r2) / 2;
    build(v, 2 * i, l2, m2);
    build(v, 2 * i + 1, m2 + 1, r2);
    st[i] = (st[2 * i] & st[2 * i + 1]);
}

void update(int l1, int x, int i = 1, int l2 = 0, int r2 = _n - 1) {
    if(l2 == r2) {
        st[i] = x;
        return;
    }

    int m2 = (l2 + r2) / 2;
    if(l1 <= m2) update(l1, x, 2 * i, l2, m2);
    else update(l1, x, 2 * i + 1, m2 + 1, r2);

    st[i] = (st[2 * i] & st[2 * i + 1]);
}

int query(int l1, int r1, int i = 1, int l2 = 0, int r2 = _n - 1) {
    if(l1 <= l2 && r2 <= r1) {
        return st[i];
    }

    int m2 = (l2 + r2) / 2;

    int ans = NEUTRAL;

    if(l1 <= m2) ans &= (query(l1, r1, 2 * i, l2, m2));
    if(m2 < r1) ans &= (query(l1, r1, 2 * i + 1, m2 + 1, r2));

    return ans;
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int n;
    cin >> n;
    _n = n;
    vector<int> v(n);
    for(auto &z : v) cin >> z;

    build(v);
    int q;
    cin >> q;

    set<int> nule[30];

    for(int i = 0; i < n; ++i) {
        for(int j = 0; j < 20; ++j) {
            if(!((v[i] >> j) & 1)) {
                nule[j].insert(i);
            }
        }
    }

    const int INF = 1e9 + 12;

    while(q--) {
        int t;
        cin >> t;

        if(t == 1) {
            int i, x;
            cin >> i >> x;
            --i;
            for(int j = 0; j < 20; ++j) {
                if(!((v[i] >> j) & 1)) {
                    nule[j].erase(i);
                }
            }

            v[i] = x;
            update(i, x);

            for(int j = 0; j < 20; ++j) {
                if(!((v[i] >> j) & 1)) {
                    nule[j].insert(i);
                }
            }
        } else {
            int gde;
            cin >> gde;
            --gde;
            int ans = INF;

            for(int iter = 0; iter < 20; ++iter) {
                auto it = nule[iter].lower_bound(gde);
                if(it == nule[iter].begin()) continue;

                int poc = *it;

                if(query(poc, n - 1) != 0) continue;

                int l = gde, r = n - 1;
                int desna = -1;

                while(l <= r) {
                    int mid = (l + r) / 2;

                    if(query(poc, mid) == 0) {
                        desna = mid;
                        r = mid - 1;
                    } else {
                        l = mid + 1;
                    }
                }

                int odg = min(gde - poc + desna - poc, desna - gde + desna - poc);
                ans = min(ans, odg);
            }

            if(query(gde, n - 1) == 0) {
                int l = gde, r = n - 1;
                int taj = -1;

                while(l <= r) {
                    int mid = (l + r) / 2;

                    if(query(gde, mid) == 0) {
                        taj = mid;
                        r = mid - 1;
                    } else {
                        l = mid + 1;
                    }
                }

                ans = min(ans, taj - gde);
            }

            if(ans == INF) ans = -1;
            cout << ans << '\n';
        }
    }
}